	function w = HAMMING_WINDOW(N)
 
	%	Computes the Hamming window of length N+1
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
 
	% 	Author: 		Lars Wanhammar 2008-07-12
	% 	Modified by: 	 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1 
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	alfa = 0.54;
	M = N+1;
	for n = 1:M
		w(n) = alfa - (1 - alfa)* cos(2*pi*(n+0.5)/M);
	end
